/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.entity.ai.goal.AttackRevengeTargetGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.EatFavouriteFoodGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FindFavouriteFoodGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FirePanicGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FollowPotentialCustomerGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.LookAtCustomerGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.TradeWithPlayerGoal;
import com.mrcrayfish.goblintraders.init.ModSounds;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractGoblinEntity
extends TraderCreatureEntity
implements INPC {
    public static final DataParameter<Boolean> STUNNED = EntityDataManager.func_187226_a(AbstractGoblinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Float> STUN_ROTATION = EntityDataManager.func_187226_a(AbstractGoblinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    @Nullable
    private PlayerEntity customer;
    private Set<UUID> tradedCustomers = new HashSet<UUID>();
    @Nullable
    private MerchantOffers offers;
    private int stunDelay;
    private int despawnDelay;
    private int fallCounter;
    private int restockDelay;

    protected AbstractGoblinEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FirePanicGoal(this, 0.5));
        this.field_70714_bg.func_75776_a(2, (Goal)new TradeWithPlayerGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtCustomerGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackRevengeTargetGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowPotentialCustomerGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new FindFavouriteFoodGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new TemptGoal((CreatureEntity)this, 0.4, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.getFavouriteFood()}), false));
        this.field_70714_bg.func_75776_a(8, (Goal)new EatFavouriteFoodGoal(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.4));
        this.field_70714_bg.func_75776_a(9, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 0.4));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 4.0f, 1.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    protected void func_213385_F() {
        super.func_213385_F();
        if (this.isStunned()) {
            this.field_70714_bg.func_220878_a(Goal.Flag.MOVE, true);
            this.field_70714_bg.func_220878_a(Goal.Flag.JUMP, true);
            this.field_70714_bg.func_220878_a(Goal.Flag.LOOK, true);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STUNNED, (Object)false);
        this.field_70180_af.func_187214_a(STUN_ROTATION, (Object)Float.valueOf(0.0f));
    }

    public abstract ResourceLocation getTexture();

    public int getFallCounter() {
        return this.fallCounter;
    }

    public ItemStack func_213357_a(World world, ItemStack stack) {
        if (stack.func_77973_b() == this.getFavouriteFood().func_77973_b() && stack.func_77973_b().func_219967_s() != null) {
            this.func_70606_j(this.func_110143_aJ() + (float)stack.func_77973_b().func_219967_s().func_221466_a());
        }
        return super.func_213357_a(world, stack);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
        if (this.stunDelay > 0) {
            --this.stunDelay;
            if (this.stunDelay == 0) {
                this.field_70180_af.func_187227_b(STUNNED, (Object)false);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)ModSounds.ENTITY_GOBLIN_TRADER_ANNOYED_GRUNT.get(), SoundCategory.NEUTRAL, 1.0f, 0.9f + this.func_70681_au().nextFloat() * 0.2f);
            }
        }
        if (!(this.field_70170_p.field_72995_K || ((Boolean)Config.COMMON.preventDespawnIfNamed.get()).booleanValue() && this.func_104002_bU())) {
            this.handleDespawn();
        } else if (((Boolean)this.field_70180_af.func_187225_a(STUNNED)).booleanValue()) {
            if (this.fallCounter < 10) {
                ++this.fallCounter;
            }
        } else {
            this.fallCounter = 0;
        }
        if (!this.field_70170_p.func_201670_d() && this.getMaxRestockDelay() != -1 && ++this.restockDelay >= this.getMaxRestockDelay()) {
            this.func_213706_dY().forEach(MerchantOffer::func_222203_h);
            this.restockDelay = 0;
        }
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        this.customer = player;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public MerchantOffers func_213706_dY() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    protected abstract void populateTradeData();

    protected void addTrades(MerchantOffers offers, @Nullable List<VillagerTrades.ITrade> trades, int max, boolean shuffle) {
        if (trades == null) {
            return;
        }
        List randomIndexes = IntStream.range(0, trades.size()).boxed().collect(Collectors.toList());
        if (shuffle) {
            Collections.shuffle(randomIndexes);
        }
        randomIndexes = randomIndexes.subList(0, Math.min(trades.size(), max));
        for (Integer index : randomIndexes) {
            VillagerTrades.ITrade trade = trades.get(index);
            MerchantOffer offer = trade.func_221182_a((Entity)this, this.field_70146_Z);
            if (offer == null) continue;
            offers.add((Object)offer);
        }
    }

    public void func_213703_a(@Nullable MerchantOffers offers) {
    }

    public void func_213704_a(MerchantOffer offer) {
        offer.func_222219_j();
        if (this.customer != null) {
            this.tradedCustomers.add(this.customer.func_110124_au());
        }
        if (this.field_70170_p instanceof ServerWorld) {
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), offer.func_222210_n()));
        }
    }

    public void func_110297_a_(ItemStack stack) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public int func_213708_dV() {
        return 0;
    }

    public void func_213702_q(int xpIn) {
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_187915_go;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() == Items.field_151057_cb) {
            heldItem.func_111282_a_(player, (LivingEntity)this, hand);
            return ActionResultType.SUCCESS;
        }
        if (!(!this.func_70089_S() || this.hasCustomer() || this.func_70631_g_() || !this.func_230279_az_() && this.func_70027_ad() || this.isStunned())) {
            if (this.func_213706_dY().isEmpty()) {
                return super.func_230254_b_(player, hand);
            }
            if (!(this.field_70170_p.field_72995_K || this.func_70643_av() != null && this.func_70643_av() == player)) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), 1);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    protected void func_226293_b_(ItemStack stack, int count) {
        if (!stack.func_190926_b() && this.func_184587_cr()) {
            if (stack.func_77975_n() == UseAction.DRINK) {
                this.func_184185_a(this.func_213351_c(stack), 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (stack.func_77975_n() == UseAction.EAT) {
                this.spawnFoodParticles(stack, count);
                this.func_184185_a(this.func_213353_d(stack), 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    protected void spawnFoodParticles(ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vector3d frontPosition = Vector3d.func_189986_a((float)0.0f, (float)this.field_70761_aq).func_186678_a(0.25);
            frontPosition = frontPosition.func_72441_c(0.0, 0.35, 0.0);
            frontPosition = frontPosition.func_178787_e(this.func_213303_ch());
            Vector3d motion = new Vector3d(this.field_70146_Z.nextDouble() * 0.2 - 0.1, 0.1, this.field_70146_Z.nextDouble() * 0.2 - 0.1);
            if (this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), frontPosition.field_72450_a, frontPosition.field_72448_b, frontPosition.field_72449_c, 1, motion.field_72450_a, motion.field_72448_b + 0.05, motion.field_72449_c, 0.0);
                continue;
            }
            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), frontPosition.field_72450_a, frontPosition.field_72448_b, frontPosition.field_72449_c, motion.field_72450_a, motion.field_72448_b + 0.05, motion.field_72449_c);
        }
    }

    public boolean isPreviousCustomer(PlayerEntity player) {
        return this.tradedCustomers.contains(player.func_110124_au());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean attacked = super.func_70097_a(source, amount);
        if (attacked && source.func_76346_g() instanceof PlayerEntity) {
            this.func_70661_as().func_75499_g();
            this.field_70180_af.func_187227_b(STUNNED, (Object)true);
            this.field_70180_af.func_187227_b(STUN_ROTATION, (Object)Float.valueOf(this.getStunRotation(source.func_76364_f())));
            this.field_70714_bg.func_220888_c().forEach(PrioritizedGoal::func_75251_c);
            this.stunDelay = 20;
        }
        return attacked;
    }

    private float getStunRotation(@Nullable Entity entity) {
        return entity != null ? entity.field_70177_z : 0.0f;
    }

    public int getStunDelay() {
        return this.stunDelay;
    }

    public void setDespawnDelay(int despawnDelay) {
        this.despawnDelay = despawnDelay;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Offers", 10)) {
            this.offers = new MerchantOffers(compound.func_74775_l("Offers"));
        }
        if (compound.func_150297_b("DespawnDelay", 3)) {
            this.despawnDelay = compound.func_74762_e("DespawnDelay");
        }
        if (compound.func_150297_b("RestockDelay", 3)) {
            this.restockDelay = compound.func_74762_e("RestockDelay");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        MerchantOffers merchantoffers = this.func_213706_dY();
        if (!merchantoffers.isEmpty()) {
            compound.func_218657_a("Offers", (INBT)merchantoffers.func_222199_a());
        }
        compound.func_74768_a("DespawnDelay", this.despawnDelay);
        compound.func_74768_a("RestockDelay", this.restockDelay);
    }

    private void handleDespawn() {
        if (this.despawnDelay > 0 && !this.hasCustomer() && --this.despawnDelay == 0) {
            this.func_70106_y();
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSounds.ENTITY_GOBLIN_TRADER_IDLE_GRUNT.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.ENTITY_GOBLIN_TRADER_IDLE_GRUNT.get();
    }

    public abstract ItemStack getFavouriteFood();

    public static AttributeModifierMap.MutableAttribute prepareAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.7);
    }

    public boolean isStunned() {
        return (Boolean)this.field_70180_af.func_187225_a(STUNNED);
    }

    public float getStunRotation() {
        return ((Float)this.field_70180_af.func_187225_a(STUN_ROTATION)).floatValue();
    }

    protected abstract int getMaxRestockDelay();

    public abstract boolean canAttackBack();
}

